# coding: utf-8

import sandbox.sdk2 as sdk2

from sandbox.projects.music.deployment.MusicBuildJars import MusicBuildJars
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.DashboardUpdater import DashboardUpdater
from sandbox.projects.music.deployment.helpers.Deployment import Deployment
from sandbox.projects.music.deployment.helpers.Nyan import nyan, MUSIC_CONTENT_CHAT_ID
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper, subtaskable
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask
import sandbox.common.types.misc as ctm

MUSIC_ADMINKA_CHAT_ID = -290775821
MUSIC_PODCASTS_CHAT_ID = -1001209691340
CHAT_NOTIFICATION = u'🛴 Запущена выкатка инкаминга, загружатор и админка подкастов будут недоступны минут 10-15'


class MusicDeployIncoming(MusicBaseTask, TaskHelper):
    """ Deploy music incoming with the rules from MUSICBACKEND-1269 """

    class Requirements(sdk2.Task.Requirements):
        environments = [TaskHelper.startrek_client_environment]
        cores = 1
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60
        description = "Deploy Music Incoming"
        revision = sdk2.parameters.Integer("The revision in trunk to deploy from", required=True)

    @subtaskable(True)
    def build(self):
        url = 'arcadia:/arc/trunk/arcadia@{}'.format(self.Parameters.revision)
        self.enqueue_subtask(MusicBuildJars,
                             url=url,
                             description='Building {}'.format(url))

    @subtaskable(True)
    def deploy(self, token, music_build_jars):
        branch_and_revision = 'trunk/{}'.format(self.Parameters.revision)
        updater = DashboardUpdater(token)
        updater.set_and_update(self.author,
                               'music-origs',
                               ['deploy-stable'],
                               music_build_jars.id,
                               branch_and_revision)

        dev_notification = u'🛴 Качу origs ({}) в бой по просьбе {}'.format(branch_and_revision, self.author)
        nyan(dev_notification)
        nyan(dev_notification, chat_id=MUSIC_CONTENT_CHAT_ID)
        nyan(CHAT_NOTIFICATION, chat_id=MUSIC_ADMINKA_CHAT_ID)
        nyan(CHAT_NOTIFICATION, chat_id=MUSIC_PODCASTS_CHAT_ID)

    def deployCached(self, token, task):
        branch_and_revision = 'trunk/{}'.format(self.Parameters.revision)
        updater = DashboardUpdater(token)
        updater.set_and_update(self.author,
                               'music-origs',
                               ['deploy-stable'],
                               task.id,
                               branch_and_revision)

        dev_notification = u'🛴 Качу origs ({}) в бой по просьбе {}'.format(branch_and_revision, self.author)
        nyan(dev_notification)
        nyan(dev_notification, chat_id=MUSIC_CONTENT_CHAT_ID)
        nyan(CHAT_NOTIFICATION, chat_id=MUSIC_ADMINKA_CHAT_ID)
        nyan(CHAT_NOTIFICATION, chat_id=MUSIC_PODCASTS_CHAT_ID)

    def on_execute(self):
        token = sdk2.Vault.data(CONFIG.token)
        self.check_authorization(self.author, CONFIG.token, CONFIG.auth_build)
        task = Deployment.find_build_task(self.Parameters.revision, 'trunk')
        if not task:
            self.build()
            self.deploy(token)
        else:
            self.deployCached(token, task)
