# coding: utf-8

import sandbox.sdk2 as sdk2
from sandbox.common import errors
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.DashboardUpdater import DashboardUpdater
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask
from sandbox.projects.music.deployment.helpers.Nyan import nyan
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper
import sandbox.common.types.misc as ctm


class MusicDeployNonSox(MusicBaseTask, TaskHelper):
    """ Deploy a non-sox component to stable """
    fail_on_any_error = True

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60  # real time ~1 min

        description = "Deploy a music non-SOX component to stable"

        task = sdk2.parameters.Task("The build task to deploy from",
                                    task_type=CONFIG.build_jars_task_type)

        with sdk2.parameters.CheckGroup("Deployment target(s)", required=True) as target:
            for name in CONFIG.components_non_sox:
                setattr(target.values, name, target.Value(name))

    def on_execute(self):
        self.check_authorization(self.author, CONFIG.token, CONFIG.auth_build)

        target_dashboards = ['music-' + x for x in self.Parameters.target]

        if not target_dashboards:
            raise errors.TaskFailure('At least one target must be specified')

        branch_and_revision = '{}/{}'.format(self.Parameters.task.Parameters.branch,
                                             self.Parameters.task.Parameters.revision)

        token = sdk2.Vault.data(CONFIG.token)
        updater = DashboardUpdater(token)
        for target_dashboard in target_dashboards:
            id_ = updater.set_and_update(self.author,
                                         target_dashboard,
                                         [CONFIG.recipes['stable']],
                                         self.Parameters.task.id,
                                         branch_and_revision)
            message = u'Started a deployment to <a href="' + \
                      CONFIG.deployment_url(target_dashboard, id_) + \
                      u'">{0}</a>'.format(target_dashboard)
            self.set_info(message, do_escape=False)

            nyan(u'🛴 Качу {} ({}) в бой по просьбе {}'
                 .format(str(self.Parameters.target), branch_and_revision, self.author))
            return

        raise errors.TaskFailure('This task is not restartable')
