# coding: utf-8

import sandbox.sdk2 as sdk2
from sandbox.projects.common.nanny.client import NannyClient
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper


class MusicDeployPR(MusicBaseTask, TaskHelper):
    """ Deploy a built PR code to the PR env """
    fail_on_any_error = True

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60           # real time ~1 min

        description = "Deploy a built PR code to the PR env"

        task = sdk2.parameters.Task("The build task to deploy from",
                                    required=True,
                                    task_type=CONFIG.build_jars_task_type)
        env_no = sdk2.parameters.Integer("The environment number to deploy to", required=True)

    def on_execute(self):
        self.check_authorization(self.author, CONFIG.token, CONFIG.auth_build)

        service_name = 'music_qa_pr_back_{}'.format(self.Parameters.env_no)
        token = sdk2.Vault.data(CONFIG.token)
        nanny = NannyClient(CONFIG.nanny_api_url, token)
        nanny.update_service_sandbox_file(service_name,
                                          CONFIG.build_jars_task_type,
                                          str(self.Parameters.task.id),
                                          deploy=True,
                                          recipe='default')
