# coding: utf-8
import logging as log

import sandbox.common.types.misc as ctm
import sandbox.sdk2 as sdk2
from sandbox.common.types import task as ctt
from sandbox.projects.common import link_builder as lb
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask
from sandbox.projects.music.deployment.helpers.Nyan import nyan
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper


class MusicDeployTests(MusicBaseTask, TaskHelper):
    """ Run music sandbox tests """

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        cores = 1

    class Parameters(sdk2.Task.Parameters):
        description = 'Deploy music tests'
        issue = sdk2.parameters.String("The deployment issue", required=True)

    def enqueue_tasks(self, tests):
        tasks = []
        for test in tests:
            log.info('Launching {}'.format(str(test.type)))
            tasks.append(self.enqueue_subtask(test, issue=self.Parameters.issue))

        raise sdk2.WaitTask(tasks,
                            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                            wait_all=True)

    @staticmethod
    def _message_builder(tasks):
        message = "Failed tests:\n"
        for task in tasks:
            message += "- [{task_name}]({link})\n".format(task_name=str(task.type),
                                                          link=lb.task_link(task.id, plain=True))
        return message

    def check_competed_tasks(self):
        tasks = self.find()
        failed_tasks = [task for task in tasks if task.status != ctt.Status.SUCCESS]
        if failed_tasks:
            message = self._message_builder(failed_tasks)
            nyan(message, raise_exception=True)

    def on_execute(self):
        for tests in CONFIG.deployment_tests:
            with self.memoize_stage["_".join([str(t.type) for t in tests])]:
                self.enqueue_tasks(tests)
        # with self.memoize_stage.enqueue_subtasks:
        #     self.enqueue_tasks()

        self.check_competed_tasks()
