# coding: utf-8

import sandbox.sdk2 as sdk2
from sandbox.projects.music.deployment.MusicStartDeployment import MusicStartDeployment
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.Deployment import Deployment
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper
import sandbox.common.types.misc as ctm


class MusicDeploymentCron(MusicBaseTask, TaskHelper):
    """ The regular cron maintenance task for Music deployment """

    class Requirements(sdk2.Task.Requirements):
        environments = [TaskHelper.startrek_client_environment]
        dns = ctm.DnsType.DNS64
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60
        description = "Regularly maintain deployment for Music"

        abc_token = sdk2.parameters.YavSecret("ABC OAuth token secret", required=True,
                                              description="Yav secret with ABC tolen",
                                              default='sec-01fp7s63sd8dgjga0erprk7tfx')

        abc_token_key = sdk2.parameters.String("Key for abc token in yav secret", required=True,
                                               default="abc_token")

        is_hourly = sdk2.parameters.Bool("Is an hourly cron", required=True)

        with is_hourly.value[True]:
            do_morning_maintenance = sdk2.parameters.Bool("Fork a branch in the morning", required=True, default=True)
            inform_startrek_fields = sdk2.parameters.Bool("Inform about startrek fields", required=True, default=True)
            inform_red_trunk = sdk2.parameters.Bool("Inform about the red trunk", required=True, default=True)

        with is_hourly.value[False]:
            check_greenness = sdk2.parameters.Bool("Cut a branch from only a green commit", required=True, default=True)

    def new_release_task(self, url):
        return MusicStartDeployment(self,
                                    mode='standard',
                                    standard_url=url,
                                    standard_skip_checks=not self.Parameters.check_greenness,
                                    notifications=self.Parameters.notifications)

    def deploy_to_stable_task(self, task):
        return MusicStartDeployment(self,
                                    mode='stable',
                                    stable_task=task,
                                    notifications=self.Parameters.notifications)

    def deploy_to_prestable_task(self, task):
        return MusicStartDeployment(self,
                                    mode='prestable',
                                    prestable_task=task,
                                    notifications=self.Parameters.notifications)

    def on_execute(self):
        self.check_authorization(self.author, CONFIG.token, CONFIG.auth_build)
        abc_token = self.Parameters.abc_token.data()[self.Parameters.abc_token_key]
        deployment = Deployment(abc_token=abc_token)

        if self.Parameters.is_hourly:
            deployment.cron_hourly(do_morning_maintenance=self.Parameters.do_morning_maintenance,
                                   inform_startrek_fields=self.Parameters.inform_startrek_fields,
                                   inform_red_trunk=self.Parameters.inform_red_trunk)
        else:
            deployment.cron_tenminute(deploy_to_stable_task=self.deploy_to_stable_task,
                                      new_release_task=self.new_release_task,
                                      deploy_to_prestable_task=self.deploy_to_prestable_task,
                                      check_greenness=self.Parameters.check_greenness)
