# coding: utf-8
import sandbox.sdk2 as sdk2
from sandbox.common import errors
from sandbox.projects.common.nanny.client import NannyClient
from sandbox.projects.music.deployment.helpers.AbcHelper import AbcHelper
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.StartrekHelper import StartrekHelper
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper


class MusicFrontendVersionCompareTest(sdk2.Task, TaskHelper):
    class Requirements(sdk2.Task.Requirements):
        environments = [TaskHelper.startrek_client_environment]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60
        description = "Frontend version compare test"

        issue = sdk2.parameters.String("Startrek issue to inform to", required=True)

        abc_token = sdk2.parameters.YavSecret("ABC OAuth token secret", required=True,
                                              description="Yav secret with ABC token",
                                              default='sec-01fp7s63sd8dgjga0erprk7tfx')

        abc_token_key = sdk2.parameters.String("Key for abc token in yav secret", required=True,
                                               default="abc_token")

    def compare_paths(self, nanny, paths):
        docker_names = set()

        for path in paths:
            service_names = [x['_id'] for x in nanny.list_services_by_category(path)['result']]
            for service_name in service_names:
                spec = nanny.get_service_instance_spec(service_name)
                docker_name = spec['content']['dockerImage']['name']
                self.set_info('Service {} has docker image {}'.format(service_name, docker_name))
                docker_names.add(docker_name)

        if len(docker_names) != 1:
            raise errors.TaskFailure(u'Different versions found')

    def on_execute(self):
        token = sdk2.Vault.data(CONFIG.token)
        st = StartrekHelper(token)
        nanny = NannyClient(CONFIG.nanny_api_url, token)

        try:
            self.compare_paths(nanny, CONFIG.nanny_frontend_paths)

            st.add_comment(self.Parameters.issue,
                           u'Сравнение версий фронтенда успешно: ((https://sandbox.yandex-team.ru/task/{0} {0}))'
                           .format(self.id))
            st.patch_release_issue_statuses_raw(self.Parameters.issue, CONFIG.monitored_deployment_test_names,
                                                self.__class__.__name__)

        except BaseException:
            abc_token = self.Parameters.abc_token.data()[self.Parameters.abc_token_key]
            self.abc_helper = AbcHelper(abc_token)
            st.add_comment(self.Parameters.issue,
                           u'Сравнение версий фронтенда !!неуспешно!!: ((https://sandbox.yandex-team.ru/task/{0} {0}))'
                           .format(self.id),
                           summonee=self.backend_on_duty())
            raise
