import logging

import requests


class BaseHttpClient(object):
    api = None

    def __init__(self, bearer=None):
        self.log = logging.getLogger(self.__class__.__bases__[0].__name__ + "." + self.__class__.__name__)
        self.api = self._verify_api_is_set()
        self._bearer = bearer
        self.log.info("Using {} as endpoint".format(self.api))

    def _verify_api_is_set(self):
        if not self.api:
            raise ValueError("No api defined")

        return self.api

    def _auth_request(self, method, **kwargs):
        headers = {
            'Authorization': 'Bearer {}'.format(self._bearer.iam)
        }

        if 'headers' in kwargs:
            kwargs['headers'].update(headers)
        else:
            kwargs['headers'] = headers

        return self._request(method, **kwargs)

    def _request(self, method, endpoint=None, **kwargs):
        # type: (str, str, dict) -> dict
        if not endpoint:
            uri = self.api
        elif endpoint[0].startswith(':'):
            uri = self.api + endpoint
        else:
            uri = self.api + "/" + endpoint

        try:
            res = requests.request(method,
                                   uri,
                                   verify=True,
                                   **kwargs)
            res.raise_for_status()
        except requests.HTTPError as ex:
            self.log.exception("Could not handle the request", exc_info=True)
            self.log.debug(res.json())
            raise
        except Exception as ex:
            self.log.exception("Could not handle the request", exc_info=True)
            raise
        return res.json()
