import time
from pprint import pformat

from .BaseHttpClient import BaseHttpClient
from .IAmBearer import IAmBearer


class MDBClient(object):
    api = "https://gw.db.yandex-team.ru"

    def __init__(self, token):
        self._bearer = IAmBearer(token)

    def cluster(self, cluster_id):
        return self._Cluster(self._bearer, cluster_id)

    def operation(self, operation_id):
        return self._Operation(self._bearer, operation_id)

    class _Operation(BaseHttpClient):
        api = "https://gw.db.yandex-team.ru/operations"

        def __init__(self, bearer, operation_id):
            super(MDBClient._Operation, self).__init__()
            self._bearer = bearer
            self.operation_id = operation_id

        def get(self):
            return self._auth_request('GET', endpoint=self.operation_id)

        def wait_for_completion(self):
            status = self.get()['done']
            while not status:
                self.log.debug(pformat(self.get()))
                status = self.get()['done']
                time.sleep(2)
            return self.get()['response']

    class _Cluster(BaseHttpClient):

        def __init__(self, bearer, cluster_id):
            # type: (IAmBearer, int) -> None
            super(MDBClient._Cluster, self).__init__()
            self._bearer = bearer
            self.cluster_id = cluster_id

        def list_backups(self):
            return self._auth_request('GET',
                                      endpoint="{}/backups".format(self.cluster_id))['backups']

        def list_hosts(self):
            return self._auth_request('GET',
                                      endpoint="{}/hosts".format(self.cluster_id))['hosts']

        def restore(self, backup_id, source_config, hosts_config, name, resource_size=None, target_folder=None):
            raise NotImplementedError

        def get(self):
            return self._auth_request('GET', endpoint=self.cluster_id)

        def delete(self):
            return self._auth_request('DELETE', endpoint=self.cluster_id)

        def list(self, folder_id):
            body = {
                'folderId': folder_id
            }
            return self._auth_request('GET', json=body)

        def update(self, config):
            return self._auth_request('PATCH', endpoint=self.cluster_id, json=config)

        def rename(self, new_name):
            config = {
                'updateMask': "name",
                'name': new_name
            }

            return self.update(config)
