from datetime import datetime

import pytz
from dateutil.parser import parse
from dateutil.relativedelta import relativedelta

from .BaseHttpClient import BaseHttpClient


class IAmBearer(BaseHttpClient):
    api = "https://iam.cloud.yandex-team.ru/v1/tokens"
    _raw_iam = {}

    def __init__(self, token):
        super(IAmBearer, self).__init__()
        self.token = token

    @property
    def iam(self):

        if self._raw_iam:
            now = datetime.now(tz=pytz.timezone("Europe/Moscow"))
            expires_time = parse(self._raw_iam["expiresAt"])

            hours = 1
            if now > expires_time - relativedelta(hours=hours):
                self.log.info("IAmToken expires in less than {} hours".format(hours))
                self._raw_iam = self._renew_iam()
            else:
                self.log.debug("Using IAmToken from cache")
        else:
            self._raw_iam = self._renew_iam()
        return self._raw_iam["iamToken"]

    def _renew_iam(self):
        self.log.info("Requesting new bearer token")
        body = {
            "yandexPassportOauthToken": self.token
        }
        return self._request('POST', json=body)
