from pprint import pformat

from .BaseMDBClient import MDBClient


class MDBMongoClient(MDBClient):

    def __init__(self, token):
        super(MDBMongoClient, self).__init__(token)

    class _Cluster(MDBClient._Cluster):
        api = MDBClient.api + "/managed-mongodb/v1/clusters"

        def get(self):
            config = super(MDBMongoClient._Cluster, self).get()

            if config['sharded']:
                raise Exception("Restoring sharded mongodb cluster is not supported")

            return config

        def restore(self, backup_id, source_config, name, hosts_config, resource_size=None, target_folder=None):
            self.log.debug("Source cluster config: \n" + pformat(source_config))
            self.log.debug("Hosts config: \n" + pformat(hosts_config))

            mongodb_spec_version = "mongodbSpec_" + source_config['config']['version'].replace('.', '_')
            mongodb_version = 'mongodb_' + source_config['config']['version'].replace('.', '_')
            cluster_config = source_config['config'][mongodb_version]['mongod']

            config = {
                'backupId': backup_id['id'],
                'time': backup_id['createdAt'],
                'name': name,
                'environment': source_config['environment'],
                'featureCompatibilityVersion': source_config['config']['featureCompatibilityVersion'],
                'configSpec': {
                    'version': source_config['config']['version'],
                    mongodb_spec_version: {
                        'mongod': {
                            'config': cluster_config['config']['effectiveConfig'],
                            'resources': cluster_config['resources']
                        }
                    },
                },
                'hostSpecs': hosts_config,
                'folderId': target_folder or source_config['folderId']
            }
            self.log.debug("Target config: \n {}".format(pformat(config)))
            return self._auth_request('POST', endpoint=":restore", json=config)
