from pprint import pformat

from .BaseMDBClient import MDBClient


class MDBMySQLClient(MDBClient):

    def __init__(self, token):
        super(MDBMySQLClient, self).__init__(token)

    class _Cluster(MDBClient._Cluster):
        api = MDBClient.api + "/managed-mysql/v1/clusters"

        def restore(self, backup_id, source_config, name, hosts_config, resource_size=None, target_folder=None):
            self.log.debug("Source cluster config: \n" + pformat(source_config))
            self.log.debug("Hosts config: \n" + pformat(hosts_config))

            if resource_size:
                source_config['config']['resources']['resourcePresetId'] = resource_size

            mysql_version = "mysqlConfig_" + source_config['config']['version'].replace('.', '_')
            config = {
                'backupId': backup_id['id'],
                'time': backup_id['createdAt'],
                'name': name,
                'environment': source_config['environment'],
                'configSpec': {
                    'version': source_config['config']['version'],
                    mysql_version: source_config['config'][mysql_version]['userConfig'],
                    'resources': source_config['config']['resources']

                },
                'hostSpecs': hosts_config,
                'folderId': target_folder or source_config['folderId']
            }
            self.log.debug("Target config: \n {}".format(pformat(config)))
            return self._auth_request('POST', endpoint=":restore", json=config)
