import requests

from sandbox import sdk2
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.music.resources import MusicOpenapiSpec


class MusicUpdateOpenapi(ReleaseToYaDeployTask2, sdk2.Task):

    YP_TOKEN_YAV_SECRET_ID = 'sec-01fc8ebjxznvc5aym6a3nndzp6'

    class Requirements(sdk2.Requirements):
        disk_space = 128

    class Parameters(sdk2.Task.Parameters):
        music_internal_api_url = sdk2.parameters.String(
            'URL to music internal api',
            required=False,
            default='http://music-web.music.qa.yandex.net/internal-api'
        )

    def on_execute(self):
        spec_bytes_url = self.Parameters.music_internal_api_url + '/openapi/external-api'
        spec_bytes = requests.get(spec_bytes_url).content
        self._upload_openapi_spec_resource(spec_bytes)

    def _upload_openapi_spec_resource(self, spec_bytes):
        resource_data = sdk2.ResourceData(MusicOpenapiSpec(self, 'Music OpenAPI spec', 'openapi_spec'))
        resource_data.path.mkdir(0o755, parents=True, exist_ok=True)
        resource_data.path.joinpath('swagger.json').write_bytes(spec_bytes)
        resource_data.ready()

    @property
    def release_template(self):
        return sdk2.ReleaseTemplate()
