import sandbox.common.types.task as ctt
from sandbox import sdk2

from sandbox.projects.music.deployment.MusicUpdateOpenapi import MusicUpdateOpenapi


class MusicUpdateOpenapiRelease(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 1
        cores = 1
        ram = 32

    class Parameters(MusicUpdateOpenapi.Parameters):
        pass

    def on_execute(self):
        with self.memoize_stage.create_children:
            update_openapi_task = MusicUpdateOpenapi(
                self,
                description='Automatically created by task MUSIC_UPDATE_OPENAPI_RELEASE {}'.format(self.id),
                music_internal_api_url=self.Parameters.music_internal_api_url
            )
            task_id = update_openapi_task.enqueue().id

            self.Context.task_id_to_release = task_id
            raise sdk2.WaitTask([task_id], ctt.Status.Group.FINISH, wait_all=True)

        self.server.release(
            task_id=self.Context.task_id_to_release,
            type=ctt.ReleaseStatus.STABLE,
            subject='OpenAPI spec release by task {}'.format(self.id)
        )
