import logging

import requests

log = logging.getLogger('AbcHelper')

MUSIC_BACKEND_SERVICE = 'musicbackend'
MUSIC_BACKEND_SCHEDULE = 'music-backend'
MUSIC_QA_SCHEDULE = 'music-backend-testing'
MUSIC_INFRA_SCHEDULE = 'music-infra'


class AbcHelper(object):
    api = "https://abc-back.yandex-team.ru"

    def __init__(self, token):
        self.token = token

    def get_onduty(self, service_slug, schedule_slug):
        # type: (str, str) -> dict
        endpoint = "/api/v4/duty/on_duty/?service__slug={service}&schedule__slug={schedule}&fields=person.login,person.name".format(
            service=service_slug, schedule=schedule_slug)
        return self._make_request('get', url=self.api + endpoint)

    def get_role_members(self, service_slug, role_scope_slug):
        # type: (str, str) -> list[str]
        endpoint = "/api/v4/services/members/?service__slug={service}&role__scope__slug={role_slug}&fields=person.login".format(
            service=service_slug, role_slug=role_scope_slug)
        res = self._make_request('get', url=self.api + endpoint)['results']
        return [x['person']['login'] for x in res]

    def _make_request(self, method, **kwargs):
        headers = {
            "Authorization": "OAuth " + self.token
        }

        try:
            ret = requests.request(method=method, headers=headers, **kwargs)
            ret.raise_for_status()
        except requests.HTTPError as ex:
            log.error("Got a request error", exc_info=True)
            if ret:
                log.error(ret.json())

        res = ret.json()
        log.info("Abc response: ", res)
        return res
