# coding: utf-8
import logging
import re
import time
from typing import Union

import requests

from .Config import CONFIG

MUSIC_BACKEND_CHAT_ID = -1001376721929
MUSIC_CONTENT_CHAT_ID = -1001439764029
YA_MUSIC_INFRA_MON_CHAT_ID = -1001270499102
KOLONKA_CHAT_ID = -551575007
CHAT_ID_TO_SLACK_URL = {
    MUSIC_BACKEND_CHAT_ID: 'https://hooks.slack.com/services/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',
    -1001411346477: 'https://hooks.slack.com/services/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',
    -1001208388220: 'https://hooks.slack.com/services/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',
    -1001433008401: 'https://hooks.slack.com/services/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',
    -1001261486614: 'https://hooks.slack.com/services/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',
    -630990206: 'https://hooks.slack.com/services/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',
    -535020754: 'https://hooks.slack.com/services/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',
    -667707112: 'https://hooks.slack.com/services/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'
}


def sanitize_for_markdown(text):
    return text.replace("_", r"\_")


def unsafe_nyan(text, chat_id, edit_message_id=None, reply_to_message_id=None, parse_mode="markdown",
                disable_notification=False):
    """
    Nyan text to the music chat

    :param text: text to meow
    :param chat_id: chat id to send to
    :param edit_message_id: the message id to be edited
    :param reply_to_message_id: if the message is a reply, ID of the original message
    :param parse_mode: telegram parse mode
    :param disable_notification: disable sound notification
    :return: message_id

    :type text: str
    :type chat_id: int
    :type edit_message_id: int
    :type parse_mode: str
    :type disable_notification: bool
    """
    json = {'text': text,
            'parse_mode': parse_mode,
            'disable_web_page_preview': True}

    if disable_notification:
        json['disable_notification'] = True

    url = '{}/proxy/telegram/raw/{}'.format(CONFIG.nyan_url, chat_id)
    if edit_message_id:
        url += '/{}'.format(edit_message_id)

    if reply_to_message_id:
        json['reply_to_message_id'] = reply_to_message_id

    resp = requests.post(url, json=json, headers={'Content-type': 'application/json'})
    resp.raise_for_status()
    job_id = resp.json()

    if edit_message_id:
        return edit_message_id

    for i in range(10):
        time.sleep(1)
        check_resp = requests.get(CONFIG.nyan_url + '/rq/jobs/{}'.format(job_id))
        check_resp.raise_for_status()
        check_result = check_resp.json()
        logging.debug("Result: " + str(check_result))
        if check_result['status'] == 'failed':
            return None
        if check_result['status'] == 'finished':
            matches = re.search(r"'message_id': (\d+)", check_result['result'])
            if not matches:
                return None
            return int(matches.group(1))


def slack_nothrow(text, chat_id):
    # type: (str, int) -> None
    try:
        if chat_id not in CHAT_ID_TO_SLACK_URL:
            return

        requests.post(CHAT_ID_TO_SLACK_URL[chat_id], json={
            # [Foo](https://foo.com) -> <https://foo.com|Foo>
            'text': re.sub(r'\[([^\]]+)\]\(([^\)]+)\)', r'<\2|\1>', text),
            'type': 'mrkdwn',
        })
    except Exception as e:
        logging.warn(e)


def nyan(text,
         edit_message_id=None,
         chat_id=MUSIC_BACKEND_CHAT_ID,
         reply_to_message_id=None,
         parse_mode="markdown",
         disable_notification=False,
         raise_exception=False):
    # type: (str, int, int, int, str, bool, bool) -> Union[int, None]
    try:
        logging.info("text: " + text + " chat_id: " + str(chat_id))

        if edit_message_id is None:
            slack_nothrow(text, chat_id)
            if chat_id == MUSIC_BACKEND_CHAT_ID:
                nyan(text, edit_message_id, KOLONKA_CHAT_ID, reply_to_message_id, parse_mode,
                     disable_notification, False)
        return unsafe_nyan(text, chat_id, edit_message_id, reply_to_message_id, parse_mode=parse_mode,
                           disable_notification=disable_notification)
    except requests.RequestException as ex:
        logging.debug(ex)
        if raise_exception:
            raise
        return None
