import logging

import requests

log = logging.getLogger('StaffHelper')


class StaffHelper(object):
    api = "https://staff-api.yandex-team.ru/v3/"

    def __init__(self, token):
        self.token = token

    def get_user_telegram(self, login):
        params = "login={login}&_fields=telegram_accounts.value&_one=1".format(login=login)
        return self.persons(params)['telegram_accounts'][0]['value']

    def persons(self, raw_params):
        url = self.api + "/persons?" + raw_params
        return self._make_request('get', url=url)

    def _make_request(self, method, **kwargs):
        headers = {
            "Authorization": "OAuth " + self.token
        }

        try:
            ret = requests.request(method=method, headers=headers, **kwargs)
            ret.raise_for_status()
        except requests.HTTPError as ex:
            log.error("Got a request error", exc_info=True)
            if ret:
                log.error(ret.json())

        return ret.json()
