import logging
import os

from sandbox.sandboxsdk.environments import SandboxEnvironment


class MongoUtilsEnvironment(SandboxEnvironment):
    """ Unlike MongodbEnvironment it adds correct PATH to executables without subfolders """
    name = 'mongodb'
    resource_type = 'MUSIC_MONGODB_UTILS'

    def prepare(self):
        logging.info('Prepare mongo utils environment, version %s' % self.version)
        mongo_utils_tar = self.get_environment_resource()
        logging.info('Mongo utils tar %s' % mongo_utils_tar)
        mongo_utils_folder = self.get_environment_folder()
        if os.path.exists(mongo_utils_folder):
            logging.info('Environment folder already exists. %s' % mongo_utils_folder)
        else:
            self.extract_tar(mongo_utils_tar, mongo_utils_folder)
        logging.info("Mongo utils folder: %s" % mongo_utils_folder)
        os.environ['PATH'] = os.path.join(mongo_utils_folder, 'bin') + ':' + os.environ['PATH']
