import sandbox.sdk2 as sdk2


# All resource names must be prefixed with "Music"

class MusicDefaultResource(sdk2.Resource):
    """ Default Music resources settings"""
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


class MusicYourkitProfile(MusicDefaultResource):
    """ Yourkit snapshot of some applciation """
    pass


class MusicJarsResource(MusicDefaultResource):
    """ Yandex Music JARs """
    branch = sdk2.parameters.String("Build branch")
    revision = sdk2.parameters.Integer("Build revision")
    patch = sdk2.parameters.String("Zipatch URL applied")


class MusicJarsBootstrapResource(MusicDefaultResource):
    """ Yandex Music JARs bootstrap code """
    pass


class MusicJarsChecksumResource(MusicDefaultResource):
    """ Yandex Music JARs checksum """
    pass


class MusicHaproxyLbConfiguratorResource(MusicDefaultResource):
    """ Yandex.Music haproxy configurator """
    pass


class MusicApiDiffResource(MusicDefaultResource):
    """ Yandex.Music qa/qable diff resource """
    pass


class MusicWsApiProxyPackage(MusicDefaultResource):
    """ Music WS API Proxy ya package bundle"""
    releasable = True
    releasers = ["robot-music-backend"]


class MusicMongodbUtils(MusicDefaultResource):
    """ Mongo utils """
    any_arch = False
    executable = True


class MongoCollectionDump(MusicDefaultResource):
    """ Dump of mongodb collection created with mongodump """
    auto_backup = True


class MusicMongoStatsExporter(MusicDefaultResource):
    """ Collect mongodb metrics for solomon """
    auto_backup = True


class StaticsOffheapArtifacts(MusicDefaultResource):
    """ A collection of artifacts downloaded from MDS """
    pass


class MusicTankAmmo(MusicDefaultResource):
    """ Music tank ammo """
    pass


class MusicTankAmmoGenerator(MusicDefaultResource):
    """ Music tank ammo generator """
    pass


class StaticsTestArtifacts(MusicDefaultResource):
    """ Statics artifacts generated by test-blob """
    auto_backup = True


class MusicJavaSecretsDeployer(MusicDefaultResource):
    """ Deploy music secret properties from yav"""
    pass


class MusicWebsocketPinger(MusicDefaultResource):
    """ Music websocket pinger utility """
    any_arch = False
    executable = True


class PortoLayerMusicBaseBionic(MusicDefaultResource):
    """ Base music porto layer """
    releasable = True


class PortoLayerMusicStoriesGenerator(MusicDefaultResource):
    """ Music stories generator porto layer """
    pass


class PortoLayerMusicSalt(MusicDefaultResource):
    """ Music salt master porto layer """
    releasable = True
    releasers = ["robot-music-backend"]


class MusicSaltMasterPackage(MusicDefaultResource):
    """ Music salt master utils and configs ya package bundle"""
    releasable = True
    releasers = ["robot-music-backend"]


class GenerativeMusicDaemon(MusicDefaultResource):
    """ Generative music backend binary """
    releasable = True
    executable = True


class GenerativeMusicData(MusicDefaultResource):
    """ Data required for the generative music backend to work """
    releasable = True


class GenerativeMusicDataLite(MusicDefaultResource):
    """ Lightweight data, configs and small jsons, required for the generative music backend to work """
    releasable = True


class GenerativeMusicTestData(MusicDefaultResource):
    """ Data required for the generative music test backend to work """
    releasable = True


class GenerativeMusicTestDataLite(MusicDefaultResource):
    """ Lightweight data, configs and small jsons, required for the generative music test backend to work """
    releasable = True


class MusicStoriesGeneratorResource(MusicDefaultResource):
    """ Jars and container scripts for stories-generator """
    releasable = True


class MusicOpenapiSpec(sdk2.Resource):
    """ Auto-generated OpenAPI documentation for music-backend"""
    releasable = True


class MusicBcdResource(MusicDefaultResource):
    """ Music BCD resource """
    releasable = True
    executable = True
    arcadia_build_path = 'music/tools/bcd2/backend/src/backend-continues-delivery'


class MusicSonosGatewayArtifacts(sdk2.Resource):
    """ Music Sonos Gateway deployment resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicPartnersArtifacts(sdk2.Resource):
    """ Music partner report deployment resources  """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMediaConnectArtifacts(sdk2.Resource):
    """ Music Media Connect deployment resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMediaConnectRedirectorArtifacts(sdk2.Resource):
    """ Music Media Connect redirector deployment resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMediaConnectGoArtifacts(sdk2.Resource):
    """ Music Media Connect golang deployment resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMediaConnectInitArtifacts(sdk2.Resource):
    """ Music Media Connect init script resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMediaConnectFlowArtifacts(sdk2.Resource):
    """ Music Media Connect Flow resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicAconcaguaCodeArtifacts(sdk2.Resource):
    """ Music aconcagua exact code resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicAconcaguaBaseArtifacts(sdk2.Resource):
    """ Music aconcagua node_modules resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicAconcaguaBuildArtifacts(sdk2.Resource):
    """ Music aconcagua node_modules resources for building """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMtsMasterhubArtifacts(sdk2.Resource):
    """ Music MTS Masterhub deployment resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicMtsPayclickArtifacts(sdk2.Resource):
    """ Music MTS Payclick deployment resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicSummitCodeArtifacts(sdk2.Resource):
    """ Music summit exact code resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicSummitBaseArtifacts(sdk2.Resource):
    """ Music summit node_modules resources """
    releasable = True
    auto_backup = True
    releasers = ["robot-music-backend"]


class MusicTagglerArtifacts(MusicDefaultResource):
    """ Music Taggler server JARs """
    pass


class MusicMongoBalancerMonitor(MusicDefaultResource):
    """ Music mongodb balancer monitor"""
    pass


# This resource should eventually replace MusicMongoBalancerMonitor
class MusicMongoMonitor(MusicDefaultResource):
    """ Music mongodb balancer monitor"""
    pass


class MusicRolesArtifacts(MusicDefaultResource):
    """ Music-roles microservice deployment resource """
    releasable = True


class MusicControlCenterArtifacts(MusicDefaultResource):
    """ Music admin control center microservice deployment resource """
    releasable = True


class MusicPlayQueueArtifacts(MusicDefaultResource):
    """ Music play queue microservice deployment resource """
    releasable = True


class MusicImportArtifacts(MusicDefaultResource):
    """ Music Import server JARs """
    releasable = True
    pass
