# -*- coding: utf-8 -*-
import os

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.nanny.nanny as nanny
import sandbox.projects.common.build.YaMake as ym

from sandbox import sdk2
from sandbox.projects.resource_types import releasers as rr


class MusicSearchApphostServant(sdk2.Resource):
    """
    ApphostServant binary
    """
    arcadia_build_path = 'extsearch/ymusic/apphost/servant/servant'
    releasable = True
    releasers = rr.music_search_releasers


class BuildMusicSearchApphostServant(ym.YaMakeTask, nanny.ReleaseToNannyTask):
    """
    Build ApphostServant binary
    """
    type = "BUILD_MUSIC_SEARCH_APPHOST_SERVANT"

    input_parameters = ym.ya_make_build_params() + build_params.get_arcadia_params() + [
        build_params.UseArcadiaApiFuse(),
        build_params.AllowArcadiaApiFallback(),
    ]

    def get_resources(self):
        resources = {
            'description': 'Build binary',
            'resource_path': os.path.basename(MusicSearchApphostServant.arcadia_build_path),
            'resource_type': MusicSearchApphostServant,
        }
        return {'project': resources}

    def get_targets(self):
        return [MusicSearchApphostServant.arcadia_build_path]

    def get_arts(self):
        return [{'path': MusicSearchApphostServant.arcadia_build_path}]

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        ym.YaMakeTask.on_release(self, additional_parameters)
