# -*- coding: utf-8 -*-
import os

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.nanny.nanny as nanny
import sandbox.projects.common.build.YaMake as ym

from sandbox import sdk2
from sandbox.projects.resource_types import releasers as rr


class MusicSrcSetup(sdk2.Resource):
    """
    Music SrcSetup binary
    """
    arcadia_build_path = 'extsearch/ymusic/apphost/src_setup/daemon'
    releasable = True
    releasers = rr.music_search_releasers


class BuildMusicSrcSetup(ym.YaMakeTask, nanny.ReleaseToNannyTask):
    """
    Build Music SrcSetup binary for apphost
    """
    type = "BUILD_MUSIC_SRC_SETUP"

    input_parameters = ym.ya_make_build_params() + build_params.get_arcadia_params() + [
        build_params.UseArcadiaApiFuse(),
        build_params.AllowArcadiaApiFallback(),
    ]

    def get_resources(self):
        resources = {
            'description': 'Build binary',
            'resource_path': os.path.basename(MusicSrcSetup.arcadia_build_path),
            'resource_type': MusicSrcSetup,
        }
        return {'project': resources}

    def get_targets(self):
        return [MusicSrcSetup.arcadia_build_path]

    def get_arts(self):
        return [{'path': MusicSrcSetup.arcadia_build_path}]

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        ym.YaMakeTask.on_release(self, additional_parameters)
