# coding=utf-8
from __future__ import print_function

import os

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.build.YaMake as ym

from sandbox.projects.music.search.resources import MusicSuggestTablesPreparer


class BuildMusicSuggestTablesPreparer(ym.YaMakeTask):

    type = "BUILD_MUSIC_SUGGEST_TABLES_PREPARER"

    input_parameters = ym.ya_make_build_params() + build_params.get_arcadia_params() + [
        build_params.UseArcadiaApiFuse(),
        build_params.AllowArcadiaApiFallback(),
    ]

    def get_resources(self):
        resources = {
            'description': 'Build binary',
            'resource_path': os.path.basename(MusicSuggestTablesPreparer.arcadia_build_path),
            'resource_type': MusicSuggestTablesPreparer,
        }
        return {'project': resources}

    def get_targets(self):
        return [MusicSuggestTablesPreparer.arcadia_build_path]

    def get_arts(self):
        return [{'path': MusicSuggestTablesPreparer.arcadia_build_path}]

    def on_release(self, additional_parameters):
        ym.YaMakeTask.on_release(self, additional_parameters)
