# coding: utf-8
import os

from sandbox.projects.common import utils
from sandbox.projects.common.nanny import nanny
from sandbox.projects.nanny.BuildNannyEtcd import resources
from sandbox.projects.nanny.common.build_helpers import git_clone_and_checkout
from sandbox.projects.nanny.common.gobabygo_parameters import GitRefIdParameter, GitRefShaParameter, ReleaseParameter
from sandbox.projects.nanny.common.environments import GoDistEnvironment
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask


class BuildNannyEtcd(nanny.ReleaseToNannyTask, SandboxTask):
    type = 'BUILD_NANNY_ETCD'
    GIT_URL = 'https://{username}:{password}@bitbucket.yandex-team.ru/scm/Nanny/etcd'

    input_parameters = [GitRefIdParameter, GitRefShaParameter, ReleaseParameter]
    environment = (
        GoDistEnvironment('1.8'),
    )

    def _get_clone_url(self):
        oauth_token = self.get_vault_data('GBG', 'nanny_robot_bb_oauth_token')
        return self.GIT_URL.format(username='x-oauth-token', password=oauth_token)

    def on_execute(self):
        ref_id = utils.get_or_default(self.ctx, GitRefIdParameter)
        ref_sha = utils.get_or_default(self.ctx, GitRefShaParameter)
        release = utils.get_or_default(self.ctx, ReleaseParameter)
        package_path = self.path('etcd')
        clone_url = self._get_clone_url()

        git_clone_and_checkout(clone_url, package_path, ref_sha or ref_id)

        if release:
            run_process('./build', work_dir=package_path, log_prefix='build script', shell=True)
            self.create_resource(
                description='etcd {}'.format(ref_id or ref_sha),
                resource_path=os.path.join(package_path, 'bin/etcd'),
                resource_type=resources.ETCD_BINARY,
                arch='linux'
            )
            self.create_resource(
                description='etcdctl {}'.format(ref_id or ref_sha),
                resource_path=os.path.join(package_path, 'bin/etcdctl'),
                resource_type=resources.ETCDCTL_BINARY,
                arch='linux'
            )


__Task__ = BuildNannyEtcd
