# coding: utf-8
import os

from sandbox.sandboxsdk.process import run_process


def git_clone_and_checkout(package_url, package_path, ref_id):
    if not os.path.exists(package_path):
        run_process(
            ['git', 'clone', package_url, package_path],
            log_prefix='git clone',
            shell=True
        )
    else:
        run_process(
            ['git', 'fetch', 'origin'],
            work_dir=package_path,
            log_prefix='git fetch',
            shell=True
        )
    run_process(
        ['git', 'checkout', '-f', ref_id],
        work_dir=package_path,
        log_prefix='git checkout',
        shell=True
    )
