# coding: utf-8
import os

from sandbox.projects import resource_types
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.paths import make_folder


class GoDistEnvironment(environments.TarballToolkitBase):
    resource_type = resource_types.GOLANG_PACKAGE.name

    def prepare(self):
        env_dir = super(GoDistEnvironment, self).prepare()
        goroot_path = os.path.join(env_dir, 'go')  # we unpacked here
        go_workspace_path = make_folder(os.path.join(env_dir, 'workspace'))

        self.update_os_env('GOROOT', goroot_path)
        self.update_os_env('GOPATH', go_workspace_path)
        self.update_os_path_env(os.path.join(goroot_path, 'bin'))
        self.update_os_path_env(os.path.join(go_workspace_path, 'bin'))
        return env_dir
