# coding: utf-8
from __future__ import absolute_import

from sandbox import sdk2

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class NETMON_SERVER(AbstractResource):
    """
        Netmon server resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel', 'efmv', 'xand', 'filsam', 'n-malakhov',
                 'robot-juggling', 'nanny-robot', 'max7255', 'zeil', 'sempav', 'kndrvt']


class NETMON_NOC_SLA_SERVER(AbstractResource):
    """
        Netmon NOC SLA server resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel', 'efmv', 'xand', 'filsam', 'n-malakhov',
                 'robot-juggling', 'nanny-robot', 'max7255', 'zeil', 'sempav', 'kndrvt']


class NETMON_RESOLVER(AbstractResource):
    """
        Netmon resolver resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel', 'efmv', 'xand', 'filsam', 'n-malakhov',
                 'robot-juggling', 'nanny-robot', 'max7255', 'zeil', 'sempav', 'kndrvt']


class NETMON_AGENT(AbstractResource):
    """
        Netmon agent resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel', 'efmv', 'xand', 'filsam', 'n-malakhov',
                 'robot-juggling', 'nanny-robot', 'max7255', 'zeil', 'sempav', 'kndrvt']


class NETMON_UI(AbstractResource):
    """
        Netmon UI resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['max7255', 'zeil', 'phenotropili', 'sempav', 'olegsenin', 'dotdot', 'robot-infracloudui']


class DECAPINGER_AGENT(AbstractResource):
    """
        Decapinger agent resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['max7255', 'zeil']


class YATTL_AGENT(AbstractResource):
    """
        YaTTL agent resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['azryve', 'alan', 'max7255', 'zeil']


class EBPF_AGENT(AbstractResource):
    """
        eBPF agent resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['max7255', 'zeil']


class GOXCART_BUNDLE(AbstractResource):
    """
        Goxcart Sidecar balancer based on L7 pginx
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['max7255', 'olegsenin', 'sivanichkin']
