# -*- coding: utf-8 -*-

import os

import sandbox.projects.neural_net.resources.resources as resources

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.build.YaMake as build_task
import sandbox.projects.common.utils as utils

import sandbox.sandboxsdk.parameters as parameters


def to_camelcase(item):
    return ''.join(x.title() for x in item.split('_'))


BUILD_TARGETS = []
for resource in resources.TARGET_RESOURCE_TYPES:
    BUILD_TARGETS.append(
        type(
            'Build{}'.format(to_camelcase(resource.executable)),
            (parameters.SandboxBoolParameter,),
            {
                'name': 'build_{}'.format(resource.executable),
                'group': 'Build targets',
                'description': 'Build {} executable'.format(to_camelcase(resource.executable)),
                'default_value': False,
                'executable': resource.executable,
            },
        )
    )


class BuildNeuralNet(build_task.YaMakeTask):
    '''
        Task to build neural-net tools
    '''

    type = 'BUILD_NEURAL_NET'

    input_parameters = build_params.get_arcadia_params() + [
        build_params.BuildType,
        build_params.BuildSystem,
        build_params.Sanitize,
        build_params.StripBinaries,
    ] + build_params.get_check_deps_params() + build_params.get_yt_store_params() + BUILD_TARGETS

    def get_resources(self):
        return {
            resource.name: {
                'description': '{} ({} for BuildNeuralNet)'.format(self.descr, resource.name),
                'resource_path': os.path.basename(resource.arcadia_build_path),
                'resource_type': resource,
            }
            for resource in resources.TARGET_RESOURCE_TYPES if self._should_build(resource)
        }

    def get_targets(self):
        return [
            resource.arcadia_build_path
            for resource in resources.TARGET_RESOURCE_TYPES if self._should_build(resource)
        ]

    def get_arts(self):
        return [
            {'path': resource.arcadia_build_path}
            for resource in resources.TARGET_RESOURCE_TYPES if self._should_build(resource)
        ]

    def _should_build(self, resource):
        return any(
            target.executable == resource.executable and utils.get_or_default(self.ctx, target)
            for target in BUILD_TARGETS
        )


__TASK__ = BuildNeuralNet
