# -*- coding: utf-8 -*-

from sandbox.sdk2 import resource
from sandbox.projects.resource_types import releasers as rr
from sandbox.projects import resource_types as rt


class NN_EXECUTABLE(resource.AbstractResource):
    '''
        Common executable options
    '''
    executable = True
    any_arch = False


class NN_COLLECT_DWELLTIME_POOL_EXECUTABLE(NN_EXECUTABLE):
    '''
        collect_dwelltime_pool executable
        See also: https://a.yandex-team.ru/arc/trunk/arcadia/quality/neural_net/train_pools/README.md
    '''
    executable = 'collect_dwelltime_pool'
    arcadia_build_path = 'quality/neural_net/train_pools/{name}/{name}'.format(name=executable)


class NN_COLLECT_RANDOM_LOG_META_POOL_EXECUTABLE(NN_EXECUTABLE):
    '''
        collect_random_log_meta_pool executable
        See also: https://a.yandex-team.ru/arc/trunk/arcadia/quality/neural_net/train_pools/README.md
    '''
    executable = 'collect_random_log_meta_pool'
    arcadia_build_path = 'quality/neural_net/train_pools/{name}/{name}'.format(name=executable)


class NN_COLLECT_STREAM_POOL_EXECUTABLE(NN_EXECUTABLE):
    '''
        collect_stream_pool executable
        See also: https://a.yandex-team.ru/arc/trunk/arcadia/quality/neural_net/train_pools/README.md
    '''
    executable = 'collect_stream_pool'
    arcadia_build_path = 'quality/neural_net/train_pools/{name}/{name}'.format(name=executable)


class WEB_BASE_OPTIMIZED_MODEL_DSSM(rt.DSSM_MODEL):
    '''
    Resource with optimized_model.dssm for web basesearch
    '''
    releasers = rr.all_dynamic_models_releasers


class WEB_BEGEMOT_OPTIMIZED_MODELS_DSSM_PACK(resource.AbstractResource):
    '''
    Resource with directory with dssm optimized models for web begemot
    '''
    readable = True
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = rr.all_dynamic_models_releasers


class WEB_RTHUB_OPTIMIZED_MODELS_DSSM_PACK(resource.AbstractResource):
    '''
    Resource with directory with dssm optimized model for web rthub
    '''
    readable = True
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = rr.all_dynamic_models_releasers


class WEB_MMETA_OPTIMIZED_MODEL_DSSM(rt.DSSM_MODEL):
    '''
    Resource with dssm optimized model for web middlesearch
    '''
    releasers = rr.all_dynamic_models_releasers


class WEB_RUNTIME_MODELS_OPTIMIZED_MODEL_DSSM(rt.DSSM_MODEL):
    '''
    Resource with dssm optimized model for web runtime models service
    '''
    releasers = rr.all_dynamic_models_releasers


class WEB_SHMICK_BASE_OPTIMIZED_MODEL_DSSM(rt.DSSM_MODEL):
    '''
    Resource with optimized_model.dssm for shmick basesearch
    '''
    releasers = rr.all_dynamic_models_releasers


# All build targets
TARGET_RESOURCE_TYPES = (
    NN_COLLECT_DWELLTIME_POOL_EXECUTABLE,
    NN_COLLECT_RANDOM_LOG_META_POOL_EXECUTABLE,
    NN_COLLECT_STREAM_POOL_EXECUTABLE,
)
