# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2

FILES = {
    "additional_rubrics.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/app_host/news_data_aas/additional_rubrics.json"
}


class BuildNewsAdditionalRubrics(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Get additional_rubrics.json
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        for filename, src_path in FILES.iteritems():
            self.download_file(src_path + "@" + str(self.Parameters.svn_revision), filename)

        additionalRubricsResource = sdk2.ResourceData(resources.NEWS_ADDITIONAL_RUBRICS_CONF(self, "additional_rubrics.json for news_data_aas", "additional_rubrics.json", ttl=28))
        additionalRubricsResource.ready()
