# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import NEWS_SKYBIT_EVLOGDUMP, news_quality


class NEWS_ANNOTATOR_EXECUTABLE(resource_types.AbstractResource):
    """
        News annotator executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + news_quality


class BuildNewsAnnotator(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News annotator
    """

    type = 'BUILD_NEWS_ANNOTATOR'

    TARGET_RESOURCES = (
        (NEWS_ANNOTATOR_EXECUTABLE, 'yweb/news/skybit/modules/annotator/skybit_annotator'),
        (NEWS_SKYBIT_EVLOGDUMP, 'yweb/news/skybit/evlogdump/skybit_evlogdump')
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsAnnotator
