# -*- coding: utf-8 -*-

from sandbox.projects.news.BuildNewsServiceConfigBundleBase2 import BuildNewsServiceConfigBundleBase2

from sandbox.projects.news import news_quality

from sandbox.projects.resource_types import news_service_config_releasers, AbstractResource


class NEWS_ANNOTATOR_INSTANCECTL_CONF(AbstractResource):
    """
        News annotator inctancectl.conf
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_service_config_releasers + news_quality


class NEWS_ANNOTATOR_CONFIG(AbstractResource):
    """
        News annotator production config
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_service_config_releasers + news_quality


class NEWS_ANNOTATOR_RESOURCES_CONF(AbstractResource):
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers + news_quality


class BuildNewsAnnotatorConfigBundle(BuildNewsServiceConfigBundleBase2):
    """Build bundle with config files for news annotator"""

    type = "BUILD_NEWS_ANNOTATOR_CONFIG_BUNDLE"

    NEWS_SERVICE_CONFIG_PATH = "yweb/news/services/annotator"
    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_ANNOTATOR_INSTANCECTL_CONF,
        "annotator.json": NEWS_ANNOTATOR_CONFIG,
        "resources.json": NEWS_ANNOTATOR_RESOURCES_CONF
    }


__Task__ = BuildNewsAnnotatorConfigBundle
