# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask


class NEWS_APPHOST_EXECUTABLE(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsAppHost(CommonBuildTask):
    """"""

    type = 'BUILD_NEWS_APPHOST'

    TARGET_RESOURCES = (
        (NEWS_APPHOST_EXECUTABLE, 'apphost/daemons/app_host/app_host'),
    )


__Task__ = BuildNewsAppHost
