# -*- coding: utf-8 -*-

from sandbox.projects.news import resources
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class BuildNewsAppHostArrangedServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news app_host arranged"""

    type = "BUILD_NEWS_APPHOST_ARRANGED_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": resources.NEWS_APPHOST_ARRANGED_INSTANCECTL_CONF,
        "recommender_system.conf": resources.NEWS_RECOMMENDER_SYSTEM_CONFIG,
        "data_server.conf": resources.NEWS_APPHOST_ARRANGED_DATA_SERVER_CONF,
        "arranged_data.conf": resources.NEWS_APPHOST_ARRANGED_DATA_CONF,
        "default_flags.conf": resources.NEWS_APPHOST_ARRANGED_DEFAULT_FLAGS,
        "run_template.sh": resources.NEWS_ARRANGED_RUN_TEMPLATE
    }


__Task__ = BuildNewsAppHostArrangedServiceConfigBundle
