# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostCacher(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.Cacher daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_CACHER'

    TARGET_RESOURCES = (
        (resources.NEWS_APPHOST_CACHER_EXECUTABLE, 'yweb/news/app_host/cacher/servant/bin/news_apphost_cacher'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/base/evlogdump/evlogdump_news_base'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_cacher'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostCacher
