# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostNewRuntime(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build NEW_RUNTIME daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_NEW_RUNTIME'

    TARGET_RESOURCES = (
        (resources.NEWS_APPHOST_NEW_RUNTIME_EXECUTABLE, 'yweb/news/app_host/new_runtime/news_apphost_new_runtime'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/new_runtime/evlogdump/evlogdump_new_runtime'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_new_runtime'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostNewRuntime
