# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostProtoRearranged(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.ProtoRearranged daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_PROTO_REARRANGED'

    TARGET_RESOURCES = (
        (resources.NEWS_APPHOST_PROTO_REARRANGED_EXECUTABLE, 'yweb/news/app_host/proto_rearranged/news_apphost_proto_rearranged'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/proto_rearranged/evlogdump/evlogdump_proto_rearranged'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_proto_rearranged'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostProtoRearranged
