# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.nanny import nanny


def replace(params, *replacement):
    result = []
    for p in params:
        found = False
        for r in replacement:
            if p.name == r.name:
                result.append(r)
                found = True
                break
        if not found:
            result.append(p)
    return result


class UseAapiFuse(build_parameters.UseArcadiaApiFuse):
    default_value = True


class UseArcInsteadOfAapi(build_parameters.UseArcInsteadOfArcadiaApi):
    default_value = True


class AapiFallback(build_parameters.AllowArcadiaApiFallback):
    default_value = True


class BuildNewsAppHostServiceBase(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build news daemon for AppHost
    """

    input_parameters = replace(
        CommonBuildTask.input_parameters,
        UseAapiFuse,
        UseArcInsteadOfAapi,
        AapiFallback
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)

        target = getattr(self, 'TARGET_TO_DUMP_SYMBOLS', '')
        if target:
            res = channel.sandbox.get_resource(self._target_resource_id(target))
            breakpad.dump_symbols(res)
