# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostSheBlender(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.SheBlender daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_SHE_BLENDER'

    TARGET_RESOURCES = (
        (resources.NEWS_APPHOST_SHE_BLENDER_EXECUTABLE, 'yweb/news/app_host/she_blender/news_apphost_she_blender'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/she_blender/evlogdump/evlogdump_she_blender'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_sport_blender'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostSheBlender
