# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types
from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsAppHostSheSetup(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News.SheSetup daemon for AppHost
    """

    type = 'BUILD_NEWS_APPHOST_SHE_SETUP'

    TARGET_RESOURCES = (
        (resources.NEWS_APPHOST_SHE_SETUP_EXECUTABLE, 'yweb/news/app_host/she_setup/news_apphost_she_setup'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/she_setup/evlogdump/evlogdump_she_setup'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_apphost_she_setup'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsAppHostSheSetup
