# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class NEWS_APPHOST_STORAGED_EXECUTABLE(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_APPHOST_STORAGED_EVLOGDUMP(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsAppHostStorageService(nanny.ReleaseToNannyTask, CommonBuildTask):
    """"""

    type = 'BUILD_NEWS_APPHOST_STORAGED'

    TARGET_RESOURCES = (
        (NEWS_APPHOST_STORAGED_EXECUTABLE, 'yweb/news/storage/server/news_storage'),
        (NEWS_APPHOST_STORAGED_EVLOGDUMP, 'yweb/news/app_host/storaged/evlogdump/evlogdump_storaged'),
    )


__Task__ = BuildNewsAppHostStorageService
