# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_APPHOST_STORAGED_INSTANCECTL_CONF(AbstractResource):
    """"""
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class NEWS_APPHOST_STORAGED_CONFIG_GENERATOR(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class BuildNewsAppHostStorageServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """"""

    type = "BUILD_NEWS_APPHOST_STORAGED_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_APPHOST_STORAGED_INSTANCECTL_CONF,
        "gen_storage_config.py": NEWS_APPHOST_STORAGED_CONFIG_GENERATOR,
    }


__Task__ = BuildNewsAppHostStorageServiceConfigBundle
