# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import NEWS_SKYBIT_EVLOGDUMP, news_quality


class NEWS_AVATARS_CONSTRUCTOR_EXECUTABLE(resource_types.AbstractResource):
    """
        News avatars constructor executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + news_quality


class BuildNewsAvatarsConstructor(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News avatars constructor
    """

    type = 'BUILD_NEWS_AVATARS_CONSTRUCTOR'

    TARGET_RESOURCES = (
        (NEWS_AVATARS_CONSTRUCTOR_EXECUTABLE, 'yweb/news/media/avatars_constructor/images-avatars-constructor'),
        (NEWS_SKYBIT_EVLOGDUMP, 'yweb/news/skybit/evlogdump/skybit_evlogdump')
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsAvatarsConstructor
