# -*- coding: utf-8 -*-

from sandbox.projects.news.BuildNewsServiceConfigBundleBase import \
    BuildNewsServiceConfigBundleBase,\
    NewsResourcesArcadiaPath

from sandbox.projects.news import news_quality

from sandbox.projects.resource_types import news_service_config_releasers, AbstractResource


class NEWS_AVATARS_CONSTRUCTOR_INSTANCECTL_CONF(AbstractResource):
    """
        News avatars constructor inctancectl.conf
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_service_config_releasers + news_quality


class NEWS_AVATARS_CONSTRUCTOR_CONFIG(AbstractResource):
    """
        News avatars constructor config
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_service_config_releasers + news_quality


class AvatarsConstructorConfPath(NewsResourcesArcadiaPath):
    description = 'avatars constructor config url:'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/avatars_constructor'


def replace(params, param):
    result = []
    for p in params:
        if param.name == p.name:
            result.append(param)
        else:
            result.append(p)
    return result


class BuildNewsAvatarsConstructorConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news avatars constructor"""

    type = "BUILD_NEWS_AVATARS_CONSTRUCTOR_CONFIG_BUNDLE"

    input_parameters = replace(BuildNewsServiceConfigBundleBase.input_parameters, AvatarsConstructorConfPath)

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_AVATARS_CONSTRUCTOR_INSTANCECTL_CONF,
        "images_avatars_constructor.json": NEWS_AVATARS_CONSTRUCTOR_CONFIG,
    }


__Task__ = BuildNewsAvatarsConstructorConfigBundle
