# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import news_quality


class NEWS_CLUSTERD_EXECUTABLE(resource_types.AbstractResource):
    """
        News clusterd executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + news_quality


class BuildNewsClusterd(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News clusterd
    """

    type = 'BUILD_NEWS_CLUSTERD'

    TARGET_RESOURCES = (
        (NEWS_CLUSTERD_EXECUTABLE, 'yweb/news/cluster/agglomerative_clusterd/agglomerative_clusterd'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsClusterd
