# -*- coding: utf-8 -*-

from sandbox.projects.news.BuildNewsServiceConfigBundleBase import \
    BuildNewsServiceConfigBundleBase,\
    NewsResourcesArcadiaPath

from sandbox.projects.news import news_quality

from sandbox.projects.resource_types import news_service_config_releasers, AbstractResource


class NEWS_CLUSTERD_INSTANCECTL_CONF(AbstractResource):
    """
        News clusterd inctancectl.conf
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_service_config_releasers + news_quality


class NEWS_CLUSTER_CLUSTERD_CONF(AbstractResource):
    """
        News clusterd production config
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_service_config_releasers + news_quality


class ClusterdConfPath(NewsResourcesArcadiaPath):
    description = 'clusterd config url:'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/clusterd'


def replace(params, param):
    result = []
    for p in params:
        if param.name == p.name:
            result.append(param)
        else:
            result.append(p)
    return result


class BuildNewsClusterdConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news clusterd"""

    type = "BUILD_NEWS_CLUSTERD_CONFIG_BUNDLE"

    input_parameters = replace(BuildNewsServiceConfigBundleBase.input_parameters, ClusterdConfPath)

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_CLUSTERD_INSTANCECTL_CONF,
        "clusterd.conf": NEWS_CLUSTER_CLUSTERD_CONF,
    }


__Task__ = BuildNewsClusterdConfigBundle
