# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
import sandbox.projects.common.build.YaPackage as pkg
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import news_quality


class NEWS_CLUSTERD_PACKAGE(resource_types.AbstractResource):
    """
        News clusterd package
    """
    releasable = True
    auto_backup = True
    releasers = resource_types.news_releasers + news_quality


def replace(params, *replacement):
    result = []
    for p in params:
        found = False
        for r in replacement:
            if p.name == r.name:
                result.append(r)
                found = True
                break
        if not found:
            result.append(p)
    return result


class ResourceTypeParameter(pkg.ResourceTypeParameter):
    default_value = NEWS_CLUSTERD_PACKAGE.name


class PackagesParameter(pkg.PackagesParameter):
    default_value = 'yweb/news/services/clusterd/pkg.json'


class PackageTypeParameter(pkg.PackageTypeParameter):
    default_value = pkg.TARBALL


class PublishPackageParameter(pkg.PublishPackageParameter):
    default_value = False


class BuildNewsClusterdPackage(nanny.ReleaseToNannyTask, pkg.YaPackage):
    """
        Build News clusterd package
    """

    type = 'BUILD_NEWS_CLUSTERD_PACKAGE'

    input_parameters = replace(
        pkg.YaPackage.input_parameters,
        ResourceTypeParameter,
        PackagesParameter,
        PackageTypeParameter,
        PublishPackageParameter)


__Task__ = BuildNewsClusterdPackage
