# -*- coding: utf-8 -*-

import __builtin__
import os
from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import news_quality
from sandbox.sandboxsdk import parameters


class NEWS_META_PQ_DYNTABLE_COPIER_EXECUTABLE(sdk2.Resource):
    """
        Extlinks, Images and VideoVH copier from PQ to dyntable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_DOCS_PQ_DYNTABLE_COPIER_EXECUTABLE(sdk2.Resource):
    """
        TNewsDocInfo copier from PQ to dyntable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_ANNOTATOR_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        filter, annotate, gemini docs
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + news_quality


class NEWS_ANNOTATOR_CLIENT_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        filter, annotate, gemini docs
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + news_quality


class NEWS_ANNOTATOR_PRE_FILTER_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        pre-filter
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + news_quality


class NEWS_AVATARS_MDS_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        upload to avatars
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_FEED_PARSER_LOGS_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        feed parser logs to yt
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_VIDEO_EMBEDDING_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        video embedding from vh to yt
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_BACKGROUND_TOLOKA_UPDATER_EXECUTABLE(sdk2.Resource):
    """
        refreshes background data with toloka results
        NEWS-16873
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_NEWSPARTNER_YDB_COPIER_EXECUTABLE(sdk2.Resource):
    """
        pushes docs and dups data to ydb for newspartner
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_DUPSD_METRICS_PQ_COPIER_EXECUTABLE(sdk2.Resource):
    """
        processes dupsd metrics from rtmr
        NEWS-18774
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


def target2field_name(target):
    return 'build_%s' % target


class BuildNewsDataFlowPQ2YTCopier(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News flexible copier services
    """

    type = 'BUILD_NEWS_DATA_FLOW_PQ2YT_COPIER'

    TARGET_RESOURCES = (
        (NEWS_AVATARS_MDS_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/avatars_mds/avatars_mds'),
        (NEWS_ANNOTATOR_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/docs/fresh/fresh'),
        (NEWS_ANNOTATOR_CLIENT_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/docs/fresh_client/fresh_client'),
        (NEWS_ANNOTATOR_PRE_FILTER_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/docs/pre_filter_fresh/pre_filter_fresh'),
        (NEWS_DOCS_PQ_DYNTABLE_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/docs/doc_pusher/doc_pusher'),
        (NEWS_META_PQ_DYNTABLE_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/meta_pusher/meta_pusher'),
        (NEWS_FEED_PARSER_LOGS_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/feed_logs_pusher/feed_logs_pusher'),
        (NEWS_VIDEO_EMBEDDING_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/video_embedding/video_embedding'),
        (NEWS_BACKGROUND_TOLOKA_UPDATER_EXECUTABLE, 'yweb/news/data_flow/services/background/main/background_updater'),
        (NEWS_NEWSPARTNER_YDB_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/newspartner/newspartner'),
        (NEWS_DUPSD_METRICS_PQ_COPIER_EXECUTABLE, 'yweb/news/data_flow/services/dupsd_metrics_processor/dupsd_metrics_processor')
    )

    class FlexibleBinaries(parameters.SandboxInfoParameter):
        name = 'flexible_binaries'
        description = 'Flexible Binaries'

    input_parameters = [FlexibleBinaries]

    for _, path in TARGET_RESOURCES:
        target = os.path.basename(path)
        field_name = target2field_name(target)
        input_parameters.extend([__builtin__.type(
            field_name,
            (sdk2.parameters.Bool,),
            dict(name=field_name, description=target),
        )])

    class MainParameters(parameters.SandboxInfoParameter):
        name = 'main_parameters'
        description = 'Common Build Task parameters'

    input_parameters += [MainParameters] + CommonBuildTask.input_parameters

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsDataFlowPQ2YTCopier
