# -*- coding: utf-8 -*-

from sandbox.projects.news.BuildNewsServiceConfigBundleBase2 import BuildNewsServiceConfigBundleBase2
from sandbox.projects.news import news_quality
from sandbox.projects.resource_types import news_service_config_releasers, AbstractResource


class NEWS_DEAD_LETTERS_FRESH_PARSER_INSTANCECTL_CONF(AbstractResource):
    """
        News dead_letters_fresh_parser instancectl.conf
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = news_service_config_releasers + news_quality


class NEWS_DEAD_LETTERS_FRESH_PARSER_CONFIG(AbstractResource):
    """
        News dead_letters_fresh_parser config
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = news_service_config_releasers + news_quality


class BuildNewsDeadLettersFreshParserConfigBundle(BuildNewsServiceConfigBundleBase2):
    """
        Build bundle with config files for news dead_letters_fresh_parser
    """
    type = "BUILD_NEWS_DEAD_LETTERS_FRESH_PARSER_CONFIG_BUNDLE"
    NEWS_SERVICE_CONFIG_PATH = "yweb/news/services/dead_letters_fresh_parser"
    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_DEAD_LETTERS_FRESH_PARSER_INSTANCECTL_CONF,
        "dead_letters_fresh_parser_config.json": NEWS_DEAD_LETTERS_FRESH_PARSER_CONFIG
    }


__Task__ = BuildNewsDeadLettersFreshParserConfigBundle
