# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class NEWS_DEAD_LETTERS_FRESH_PARSER_EXECUTABLE(resource_types.AbstractResource):
    """
        yweb/news/tools/dead_letters_fresh_parser executable
        reads rthub's deadletter PQ
        uploads news errors to YT
        sends statistics to Golovan
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsDeadLettersFreshParserExecutable(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build yweb/news/tools/dead_letters_fresh_parser executable
    """
    type = 'BUILD_NEWS_DEAD_LETTERS_FRESH_PARSER_EXECUTABLE'
    TARGET_RESOURCES = (
        (NEWS_DEAD_LETTERS_FRESH_PARSER_EXECUTABLE, 'yweb/news/tools/dead_letters_fresh_parser/dead_letters_fresh_parser'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsDeadLettersFreshParserExecutable
