# -*- coding: utf-8 -*-

import sandbox.projects.common.build.YaPackage as pkg
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.news.parameters import replace_parameters_default_value
from sandbox.projects.resource_types import NEWS_INDEXER_PACKAGE


class BuildNewsIndexerPackage(pkg.YaPackage):
    """
        Build news indexer
    """

    type = 'BUILD_NEWS_INDEXER_PACKAGE'

    input_parameters = replace_parameters_default_value(pkg.YaPackage.input_parameters, {
        pkg.ResourceTypeParameter: NEWS_INDEXER_PACKAGE.name,
        pkg.PackagesParameter: "yweb/news/pkg/json/indexer.json",
        pkg.PackageTypeParameter: pkg.TARBALL,
        pkg.CompressPackageArchiveParameter: False,
        pkg.UseNewFormatParameter: True,

        build_parameters.UseArcadiaApiFuse: True,
        build_parameters.UseArcInsteadOfArcadiaApi: True,
        build_parameters.AllowArcadiaApiFallback: True,
        build_parameters.BuildType: "release",
    })


__Task__ = BuildNewsIndexerPackage
