# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import NEWS_SKYBIT_EVLOGDUMP


class NEWS_KNOCKER_EXECUTABLE(resource_types.AbstractResource):
    """
        News knocker executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsKnocker(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News knocker
    """

    type = 'BUILD_NEWS_KNOCKER'

    TARGET_RESOURCES = (
        (NEWS_KNOCKER_EXECUTABLE, 'yweb/news/knocker/knocker'),
        (NEWS_SKYBIT_EVLOGDUMP, 'yweb/news/skybit/evlogdump/skybit_evlogdump')
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsKnocker
